% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_change}
\alias{plot_change}
\title{Pairwise differences}
\usage{
plot_change(
  x,
  y0,
  y1,
  y2,
  dist = 0.15,
  main = "",
  cex.axis = 0.5,
  cex.main = 1,
  increase = TRUE
)
}
\arguments{
\item{x}{setting: character vector}

\item{y0}{values on the left: numeric vector}

\item{y1}{values in the centre: numeric vector}

\item{y2}{values on the right: numeric vector}

\item{dist}{horizontal distance between points}

\item{main}{title}

\item{cex.axis}{numeric}

\item{cex.main}{numeric}

\item{increase}{change to arrow NULL, up, down}
}
\value{
Returns \code{NULL}. Generates a plot.
}
\description{
Visualises differences within sets of three values in different settings.
}
\examples{
m <- 3 # number of settings
n <- 5 # number of repetitions
x <- rep(LETTERS[1:m],each=n)
y0 <- stats::rnorm(n*m,mean=0)
y1 <- stats::rnorm(n*m,mean=ifelse(x=="A",2,-2))
y2 <- stats::rnorm(n*m,mean=ifelse(x=="A",4,-4))
plot_change(x,y0,y1,y2)

}
\keyword{internal}
