% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fns.R
\name{Takahashi_Davis}
\alias{Takahashi_Davis}
\title{Takahashi equations}
\usage{
Takahashi_Davis(Q = NULL, cholQp = NULL, return_perm_chol = 0, P = 0,
  gc = 0)
}
\arguments{
\item{Q}{precision matrix of class \code{matrix}, \code{Matrix} (column-compressed, i.e., \code{dgCMatrix} or \code{dsCMatrix}), or \code{spam}}

\item{cholQp}{the Cholesky factor of class \code{dtCMatrix} of the permuted \code{Q} (if known already). If both \code{Q} and \code{cholQp} are specified, \code{Q} is ignored}

\item{return_perm_chol}{if 1, the Cholesky factor of the permuted \code{Q} is returned}

\item{P}{the permutation matrix of class \code{dgCMatrix} (if known already)}

\item{gc}{do garbage collection throughout (may increase computational time but useful for small memory machines)}
}
\value{
if return_perm_chol == 0, the sparse inverse subset of Q is returned, where the non-zero elements correspond to those in the Cholesky factor of its permutation.
If !(return_perm_chol  == 0), a list with three elements is returned: \code{S} (the sparse inverse subset), Lp (the Cholesky factor of the permuted matrix) and P (the
permutation matrix)
}
\description{
Computes the sparse inverse subset of a sparse matrix \code{Q} using the Takahashi equations.
}
\details{
This function first computes the Cholesky factor of \code{Q}. The fill-in reduction permutation is the approximate minimum degree permutation (amd) of Timothy Davis' SuiteSparse package configured to be slightly more aggressive than that in the \code{Matrix} package. The function then uses the Takahashi equations to compute the variances at the non-zero locations in the Cholesky factor from the factor itself. The equations themselves are implemented in C using the SparseSuite package of Timothy Davis.
}
\note{
This package is a wrapper for C functions implemented by Timothy Davis in SuiteSparse. The author of this package has done no work on the sparse inverse routines themselves and any acknowledgment should include one to SuiteSparse (see below for reference). The author of this package was made aware of this methodology by Botond Cseke.
}
\examples{
require(Matrix)
Q = sparseMatrix(i = c(1, 1, 2, 2),
                 j = c(1, 2, 1, 2),
                 x = c(0.1, 0.2, 0.2, 1))
X <- cholPermute(Q)
S_partial = Takahashi_Davis(Q, cholQp = X$Qpermchol, P = X$P)
}
\references{
Takahashi, K., Fagan, J., Chin, M.-S., 1973. Formation of a sparse bus impedance matrix and its application to short circuit study. 8th PICA Conf. Proc. June 4--6, Minneapolis, Minn.

Davis, T. A., 2014. sparseinv: Sparse Inverse Subset. URL https://au.mathworks.com/matlabcentral/fileexchange/33966-sparseinv--sparse-inverse-subset
Davis, T. A., 2006. Direct Methods for Sparse Linear Systems. SIAM, Philadelphia, PA.
}
\keyword{Cholesky}
\keyword{factor,}
\keyword{inverse}
\keyword{sparse}
\keyword{subset}
