% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_regression_isotonic_regression.R
\name{ml_isotonic_regression}
\alias{ml_isotonic_regression}
\title{Spark ML -- Isotonic Regression}
\usage{
ml_isotonic_regression(
  x,
  formula = NULL,
  feature_index = 0,
  isotonic = TRUE,
  weight_col = NULL,
  features_col = "features",
  label_col = "label",
  prediction_col = "prediction",
  uid = random_string("isotonic_regression_"),
  ...
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{formula}{Used when \code{x} is a \code{tbl_spark}. R formula as a character string or a formula. This is used to transform the input dataframe before fitting, see \link{ft_r_formula} for details.}

\item{feature_index}{Index of the feature if \code{features_col} is a vector column (default: 0), no effect otherwise.}

\item{isotonic}{Whether the output sequence should be isotonic/increasing (true) or antitonic/decreasing (false). Default: true}

\item{weight_col}{The name of the column to use as weights for the model fit.}

\item{features_col}{Features column name, as a length-one character vector. The column should be single vector column of numeric values. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{label_col}{Label column name. The column should be a numeric column. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{prediction_col}{Prediction column name.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; see Details.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} object. If
it is a \code{ml_pipeline}, it will return a pipeline with the predictor
appended to it. If a \code{tbl_spark}, it will return a \code{tbl_spark} with
the predictions added to it.
}
\description{
Currently implemented using parallelized pool adjacent violators algorithm. Only univariate (single feature) algorithm supported.
}
\examples{
\dontrun{
sc <- spark_connect(master = "local")
iris_tbl <- sdf_copy_to(sc, iris, name = "iris_tbl", overwrite = TRUE)

partitions <- iris_tbl \%>\%
  sdf_random_split(training = 0.7, test = 0.3, seed = 1111)

iris_training <- partitions$training
iris_test <- partitions$test

iso_res <- iris_tbl \%>\%
  ml_isotonic_regression(Petal_Length ~ Petal_Width)

pred <- ml_predict(iso_res, iris_test)

pred
}

}
\seealso{
Other ml algorithms: 
\code{\link{ml_aft_survival_regression}()},
\code{\link{ml_decision_tree_classifier}()},
\code{\link{ml_gbt_classifier}()},
\code{\link{ml_generalized_linear_regression}()},
\code{\link{ml_linear_regression}()},
\code{\link{ml_linear_svc}()},
\code{\link{ml_logistic_regression}()},
\code{\link{ml_multilayer_perceptron_classifier}()},
\code{\link{ml_naive_bayes}()},
\code{\link{ml_one_vs_rest}()},
\code{\link{ml_random_forest_classifier}()}
}
\concept{ml algorithms}
