% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{spk_add_deps}
\alias{spk_add_deps}
\title{Add Sparkline Dependencies to Tag or 'htmlwidget'}
\usage{
spk_add_deps(tag_htmlwidget = NULL)
}
\arguments{
\item{tag_htmlwidget}{\code{shiny.tag} or \code{htmlwidget} to which
you would like to add \code{sparkline} dependencies}
}
\value{
\code{shiny.tag} or \code{htmlwidget}
}
\description{
Add Sparkline Dependencies to Tag or 'htmlwidget'
}
\examples{
# use spk_add_deps with other htmlwidgets

library(sparkline)
library(formattable)

fw <- as.htmlwidget(
  formattable(
    data.frame(
      id = c("a", "b"),
      sparkline = c(
        spk_chr(runif(10,0,10), type="bar"),
        spk_chr(runif(10,0,5), type="bar")
      ),
      stringsAsFactors = FALSE
    )
  )
)

spk_add_deps(fw)

# use spk_add_deps with htmltools/shiny tags

library(sparkline)
library(htmltools)

div <- tags$div(
  spk_chr(1:10, type="bar")
)

spk_add_deps(div)
}

