% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_pcv}
\alias{compute_pcv}
\title{Compute PCV (Portion de Ciel Visible) for point cloud}
\usage{
compute_pcv(las, radius = 1, num_directions = 60, ncpu = 4)
}
\arguments{
\item{las}{LAS object}

\item{radius}{Numeric radius for neighborhood search}

\item{num_directions}{Integer number of directional rays to cast}

\item{ncpu}{Integer number of CPUs to use for parallel processing}
}
\value{
Numeric vector of PCV values (sky visibility) for each point
}
\description{
Calculates ambient occlusion using sky visibility algorithm.
Based on Duguet & Girardeau-Montaut (2004).
}
\details{
The PCV algorithm computes the visible portion of the sky from each point by:
\itemize{
\item Casting rays in multiple directions around each point
\item Computing the maximum elevation angle (horizon) in each direction
\item Calculating the average sky visibility across all directions
}

This function uses an optimized C++ implementation with OpenMP parallelization
for improved performance on large point clouds.
}
\keyword{internal}
