% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stvcGLMstack.R
\name{stvcGLMstack}
\alias{stvcGLMstack}
\title{Bayesian spatially-temporally varying coefficients generalized linear model
using predictive stacking}
\usage{
stvcGLMstack(
  formula,
  data = parent.frame(),
  family,
  sp_coords,
  time_coords,
  cor.fn,
  process.type,
  priors,
  candidate.models,
  n.samples,
  loopd.controls,
  parallel = FALSE,
  solver = "ECOS",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{a symbolic description of the regression model to be fit.
Variables in parenthesis are assigned spatially-temporally varying
coefficients. See examples.}

\item{data}{an optional data frame containing the variables in the model.
If not found in \code{data}, the variables are taken from
\code{environment(formula)}, typically the environment from which
\code{stvcGLMstack} is called.}

\item{family}{Specifies the distribution of the response as a member of the
exponential family. Supported options are \code{'poisson'}, \code{'binomial'} and
\code{'binary'}.}

\item{sp_coords}{an \eqn{n \times 2}{n x 2} matrix of the observation
spatial coordinates in \eqn{\mathbb{R}^2} (e.g., easting and northing).}

\item{time_coords}{an \eqn{n \times 1}{n x 1} matrix of the observation
temporal coordinates in \eqn{\mathcal{T} \subseteq [0, \infty)}.}

\item{cor.fn}{a quoted keyword that specifies the correlation function used
to model the spatial-temporal dependence structure among the observations.
Supported covariance model key words are: \code{'gneiting-decay'} (Gneiting
and Guttorp 2010). See below for details.}

\item{process.type}{a quoted keyword specifying the model for the
spatial-temporal process. Supported keywords are \code{'independent'} which
indicates independent processes for each varying coefficients characterized
by different process parameters, \code{independent.shared} implies independent
processes for the varying coefficients that shares common process parameters,
and \code{multivariate} implies correlated processes for the varying coefficients
modeled by a multivariate Gaussian process with an inverse-Wishart prior on
the correlation matrix. The input for \code{sptParams} and \code{priors} must be given
accordingly.}

\item{priors}{(optional) a list with each tag corresponding to a
hyperparameter name and containing hyperprior details. Valid tags include
\code{V.beta}, \code{nu.beta}, \code{nu.z}, \code{sigmaSq.xi} and \code{IW.scale}. Values of \code{nu.beta}
and \code{nu.z} must be at least 2.1. If not supplied, uses defaults.}

\item{candidate.models}{an object of class \code{candidateModels} containing a
list of candidate models for stacking. See \code{\link[=candidateModels]{candidateModels()}} for details.}

\item{n.samples}{number of samples to be drawn from the posterior
distribution.}

\item{loopd.controls}{a list with details on how leave-one-out predictive
densities (LOO-PD) are to be calculated. Valid tags include \code{method}, \code{CV.K}
and \code{nMC}. The tag \code{method} can be either \code{'exact'} or \code{'CV'}. If sample size
is more than 100, then the default is \code{'CV'} with \code{CV.K} equal to its default
value 10 (Gelman \emph{et al.} 2024). The tag \code{nMC} decides how many Monte Carlo
samples will be used to evaluate the leave-one-out predictive densities,
which must be at least 500 (default).}

\item{parallel}{logical. If \code{parallel=FALSE}, the parallelization plan,
if set up by the user, is ignored. If \code{parallel=TRUE}, the function
inherits the parallelization plan that is set by the user via the function
\code{\link[future:plan]{future::plan()}} only. Depending on the parallel backend available, users
may choose their own plan. More details are available at
\url{https://cran.R-project.org/package=future}.}

\item{solver}{(optional) Specifies the name of the solver that will be used
to obtain optimal stacking weights for each candidate model. Default is
\code{'ECOS'}. Users can use other solvers supported by the
\link[CVXR]{CVXR-package} package.}

\item{verbose}{logical. If \code{TRUE}, prints model-specific optimal
stacking weights.}

\item{...}{currently no additional argument.}
}
\value{
An object of class \code{stvcGLMstack}, which is a list including the
following tags -
\describe{
\item{\code{samples}}{a list of length equal to total number of candidate models
with each entry corresponding to a list of length 3, containing posterior
samples of fixed effects (\code{beta}), spatial effects (\code{z}), and
fine scale variation \code{xi} for that model.}
\item{\code{loopd}}{a list of length equal to total number of candidate models with
each entry containing leave-one-out predictive densities under that
particular model.}
\item{\code{n.models}}{number of candidate models that are fit.}
\item{\code{candidate.models}}{a list of length \code{n_model} rows with each
entry containing details of the model parameters.}
\item{\code{stacking.weights}}{a numeric vector of length equal to the number of
candidate models storing the optimal stacking weights.}
\item{\code{run.time}}{a \code{proc_time} object with runtime details.}
\item{\code{solver.status}}{solver status as returned by the optimization
routine.}
}
This object can be further used to recover posterior samples of the scale
parameters in the model, and subsequrently, to make predictions at new
locations or times using the function \code{\link[=posteriorPredict]{posteriorPredict()}}.
}
\description{
Fits Bayesian spatial-temporal generalized linear model with
spatially-temporally varying coefficients on a collection of candidate models
constructed based on some candidate values of some model parameters specified
by the user and subsequently combines inference by stacking predictive
densities. See Pan, Zhang, Bradley, and Banerjee (2025) for more details.
}
\examples{
\donttest{
set.seed(1234)
data("sim_stvcPoisson")
dat <- sim_stvcPoisson[1:100, ]

# create list of candidate models (multivariate)
mod.list2 <- candidateModels(list(phi_s = list(2, 3),
                                  phi_t = list(1, 2),
                                  boundary = c(0.5, 0.75)), "cartesian")

# fit a spatial-temporal varying coefficient model using predictive stacking
mod1 <- stvcGLMstack(y ~ x1 + (x1), data = dat, family = "poisson",
                     sp_coords = as.matrix(dat[, c("s1", "s2")]),
                     time_coords = as.matrix(dat[, "t_coords"]),
                     cor.fn = "gneiting-decay",
                     process.type = "multivariate",
                     candidate.models = mod.list2,
                     loopd.controls = list(method = "CV", CV.K = 10, nMC = 500),
                     n.samples = 500)
}
}
