% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\docType{package}
\name{sotu-package}
\alias{sotu}
\alias{sotu-package}
\title{sotu: State of the Union Addresses}
\description{
The President of the United States is constitutionally
obligated to provide a report of the current state of
country. While historically this could be a written
document, in modern times this has always taken the
form of an oral address to a joint session of the
US Congress. This package provides the raw text from
every State of the Union address, with the intention
of being used for meaningful examples of text analysis
in R. This corpus is well-suited to the task as a it
historically important, includes both material intended
to be read and material intended to be spoken, and it
falls in the public domain. As the corpus spans over
two centuries it is also a good test of how well various
methods hold up to the idiosyncrasies of historical texts.
}
\details{
A metadata table containing information about each speech
is also included in the package. This includes information
about the date and president giving the address. Note that
some of the addresses contained in the archive are not
technically State of the Union Addresses, but are more
general Addresses to a Joint Session of Congress. Usually
these occur following a new president's inauguration, and
are historically treated as no different than a standard
State of the Union.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/statsmaths/sotu/}
  \item Report bugs at \url{https://github.com/statsmaths/sotu/issues/}
}

}
\author{
\strong{Maintainer}: Taylor B. Arnold \email{tarnold2@richmond.edu}

}
