% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sotkanet_indicators.R
\name{sotkanet_indicators}
\alias{sotkanet_indicators}
\title{Sotkanet Indicators}
\usage{
sotkanet_indicators(
  id = NULL,
  type = "table",
  lang = "fi",
  user.agent = NULL,
  cache = TRUE,
  cache_dir = NULL
)
}
\arguments{
\item{id}{Dataset identifier. Default is NULL returning all}

\item{type}{type output format, either 'table' (default) or 'raw'.
Default produces a truncated table with strictly defined columns that
are useful in other functions. 'Raw' produces the full output which might
be useful for exploratory purposes.}

\item{lang}{Language of the output.}

\item{user.agent}{"User agent" defined by the user. Default is NULL which
will then use the package identifier "rOpenGov/sotkanet"}

\item{cache}{a logical whether to do caching.}

\item{cache_dir}{a path to the cache dir.}
}
\value{
data.frame (type = "table) or a list (type = "raw")
}
\description{
Retrieve Sotkanet indicator metadata
}
\details{
Data is fetched from \url{https://sotkanet.fi/rest/1.1/indicators}.
}
\examples{
\dontrun{
sotkanet.indicators <- sotkanet_indicators(type = "table", lang = "fi")
}
}
\references{
See citation("sotkanet")
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}, Pyry Kantanen
}
\keyword{utilities}
