% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.visual.R
\name{som.nn.visual}
\alias{som.nn.visual}
\title{Mapping function for SOMnn}
\usage{
som.nn.visual(codes, data)
}
\arguments{
\item{codes}{\code{data.frame} with codebook vectors.}

\item{data}{\code{data.frame} with data to be mapped. Columns of \code{x}
must have the same names as columns of \code{codes}.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   \code{data.frame} with 2 columns:
           \\itemize\{
           \\item Index of the winner neuron for each row (index starting at 1).
           \\item Distance between winner and row.
           \}
}\if{html}{\out{</div>}}
}
\description{
Maps a sample of unknown category to a self-organising map (SOM)
stored in a object of type SOMnn.
}
\details{
The function returns the winner neuron in \code{codes} for
each test vector in \code{x}.
\code{codes} and \code{x} are one vector per row and must have
the same number of columns (i.e. dimensions) and the identical column names.

\code{som.nn.visual} is the work horse for the k-NN-like classifier and normally used
from \code{predict}.
}
