% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whomineralizes.R
\name{whomineralizes}
\alias{whomineralizes}
\title{Direct and indirect contributions to mineralizations}
\usage{
whomineralizes(usin, selected = NULL)
}
\arguments{
\item{usin}{The community in which we want to calculate mineralization rates.}

\item{selected}{A vector of names for which you want to calculate the direct and indirect effects. Default NULL means all of them. Useful for excluding nodes whose removal breaks the community (i.e., basal nodes)}
}
\value{
A table of node effects on mineralization rates.
}
\description{
Direct and indirect contributions to mineralizations
}
\details{
The results are labeled as follows with direct contributions calculated from the full food web and indirect contributions calculated from the food web without that node. Indirect contributions do not include the direct contribution (i.e., it is subtracted).

\describe{
  \item{DirectC}{The direct contribution to carbon mineralization.}
  \item{DirectN}{The direct contribution to nitrogen mineralization.}
  \item{IndirectC}{The indirect contribution to carbon mineralization.}
  \item{IndirectN}{The indirect contribution to nitrogen mineralization.}
}
The indirect contributions are calculated as the total mineralization of the community with the trophic species minus the trophic species direct mineralization minus the total mineralization without the trophic species all divided by the total mineralizaiton with the trophic species.
}
\examples{
# Basic example for the introductory community:
whomineralizes(intro_comm)
}
