% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/social.plot.R
\name{social.plot}
\alias{social.plot}
\title{Social scatterplot}
\usage{
social.plot(x, S, ...)
}
\arguments{
\item{x}{a numeric vector of social data.}

\item{S}{a social correlation matrix.}

\item{...}{further arguments to be passed to \code{\link{plot}}.}
}
\value{
None
}
\description{
A plot of social data against its socially lagged values
}
\examples{
A = matrix(c(0,1,0,1,0,
             1,0,0,1,1,
             0,0,0,1,1,
             1,1,1,0,0,
             0,1,1,0,0), nrow=5)
S = social.cor.matrix(A)
x = rnorm(nrow(A))
social.plot(x, S, ylim=c(min(x),max(x)), xlab="x", ylab="Socially lagged x")
abline(0, 1, lty=2)

}
