\name{ddoublex}
\alias{ddoublex}
\alias{rdoublex}
\title{The double exponential (Laplace) distribution}
\description{
  Density for and random values from double exponential (Laplace)
  distribution with density \code{exp(-abs(x-mu)/lambda)/(2*lambda)},
  for which the median is the ML estimator.
}
\usage{
  ddoublex(x, mu=0, lambda=1)
  rdoublex(n,mu=0,lambda=1)
}
\arguments{
  \item{x}{numeric vector.}
  \item{mu}{numeric. Distribution median.}
  \item{lambda}{numeric. Scale parameter.}
  \item{n}{integer. Number of random values to be generated.}

}
\details{
  \describe{
    \item{ddoublex:}{density.}
    \item{rdoublex:}{random number generation.}
  }
}

\value{
  \code{ddoublex} gives out a vector of density values.
  
  \code{rdoublex} gives out a vector of random numbers generated by
  the double exponential distribution.
}
\references{
  Huber, P. J. and Ronchetti, E. (2009) Robust Statistics (2nd
  ed.). Wiley, New York.
}
\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche/}
}
\examples{
  set.seed(123456)
  ddoublex(1:5,lambda=5)
  rdoublex(5,mu=10,lambda=5)
} 
\keyword{distribution}

