% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSingleObjectiveFunction.R
\name{makeSingleObjectiveFunction}
\alias{makeSingleObjectiveFunction}
\title{Generator for single-objective target functions.}
\usage{
makeSingleObjectiveFunction(
  name = NULL,
  id = NULL,
  description = NULL,
  fn,
  has.simple.signature = TRUE,
  vectorized = FALSE,
  par.set,
  noisy = FALSE,
  fn.mean = NULL,
  minimize = TRUE,
  constraint.fn = NULL,
  tags = character(0),
  global.opt.params = NULL,
  global.opt.value = NULL,
  local.opt.params = NULL,
  local.opt.values = NULL
)
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Function name. Used for the title of plots for example.}

\item{id}{[\code{character(1)} | \code{NULL}]\cr
Optional short function identifier. If provided, this should be a short
name without whitespaces and now special characters beside the underscore.
Default is \code{NULL}, which means no ID at all.}

\item{description}{[\code{character(1)} | \code{NULL}]\cr
Optional function description.}

\item{fn}{[\code{function}]\cr
Objective function.}

\item{has.simple.signature}{[\code{logical(1)}]\cr
Set this to \code{TRUE} if the objective function expects a vector as input and \code{FALSE}
if it expects a named list of values. The latter is needed if the function depends on mixed
parameters. Default is \code{TRUE}.}

\item{vectorized}{[\code{logical(1)}]\cr
Can the objective function handle \dQuote{vector} input, i.~e., does it
accept matrix of parameters? Default is \code{FALSE}.}

\item{par.set}{[\code{\link[ParamHelpers]{ParamSet}}]\cr
Parameter set describing different aspects of the objective function parameters, i.~e.,
names, lower and/or upper bounds, types and so on. See \code{\link[ParamHelpers]{makeParamSet}}
for further information.}

\item{noisy}{[\code{logical(1)}]\cr
Is the function noisy? Defaults to \code{FALSE}.}

\item{fn.mean}{[\code{function}]\cr
Optional true mean function in case of a noisy objective function. This functions should
have the same mean as \code{fn}.}

\item{minimize}{[\code{logical(1)}]\cr
Set this to \code{TRUE} if the function should be minimized and to
\code{FALSE} otherwise.
The default is \code{TRUE}.}

\item{constraint.fn}{[\code{function | NULL}]\cr
Function which returns a logical vector indicating whether certain conditions
are met or not. Default is \code{NULL}, which means, that there are no constraints
beside possible box constraints defined via the \code{par.set} argument.}

\item{tags}{[\code{character}]\cr
Optional character vector of tags or keywords which characterize the function,
e.~g. \dQuote{unimodal}, \dQuote{separable}. See \code{\link{getAvailableTags}} for
a character vector of allowed tags.}

\item{global.opt.params}{[\code{list} | \code{numeric} | \code{data.frame} | \code{matrix} | \code{NULL}]\cr
Default is \code{NULL} which means unknown. Passing a \code{numeric} vector will
be the most frequent case (numeric only functions). In this case there is only a
single global optimum. If there are multiple global optima, passing a numeric
\code{matrix} is the best choice. Passing a \code{list} or a \code{data.frame}
is necessary if your function is mixed, e.g., it expects both numeric and discrete
parameters. Internally, however, each representation is casted to a \code{data.frame}
for reasons of consistency.}

\item{global.opt.value}{[\code{numeric(1)} | \code{NULL}]\cr
Global optimum value if known. Default is \code{NULL}, which means unknown. If
only the \code{global.opt.params} are passed, the value is computed automatically.}

\item{local.opt.params}{[\code{list} | \code{numeric} | \code{data.frame} | \code{matrix} | \code{NULL}]\cr
Default is \code{NULL}, which means the function has no local optima or they are
unknown. For details see the description of \code{global.opt.params}.}

\item{local.opt.values}{[\code{numeric} | \code{NULL}]\cr
Value(s) of local optima. Default is \code{NULL}, which means unknown. If
only the \code{local.opt.params} are passed, the values are computed automatically.}
}
\value{
[\code{function}] Objective function with additional stuff attached as attributes.
}
\description{
Generator for single-objective target functions.
}
\examples{
library(ggplot2)

fn = makeSingleObjectiveFunction(
  name = "Sphere Function",
  fn = function(x) sum(x^2),
  par.set = makeNumericParamSet("x", len = 1L, lower = -5L, upper = 5L),
  global.opt.params = list(x = 0)
)
print(fn)
print(autoplot(fn))

fn.num2 = makeSingleObjectiveFunction(
  name = "Numeric 2D",
  fn = function(x) sum(x^2),
  par.set = makeParamSet(
    makeNumericParam("x1", lower = -5, upper = 5),
    makeNumericParam("x2", lower = -10, upper = 20)
  )
)
print(fn.num2)
print(autoplot(fn.num2))

fn.mixed = makeSingleObjectiveFunction(
  name = "Mixed 2D",
  fn = function(x) x$num1^2 + as.integer(as.character(x$disc1) == "a"),
  has.simple.signature = FALSE,
  par.set = makeParamSet(
    makeNumericParam("num1", lower = -5, upper = 5),
    makeDiscreteParam("disc1", values = c("a", "b"))
  ),
  global.opt.params = list(num1 = 0, disc1 = "b")
)
print(fn.mixed)
print(autoplot(fn.mixed))
}
