% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mof.dtlz5.R
\name{makeDTLZ5Function}
\alias{makeDTLZ5Function}
\title{DTLZ5 Function (family)}
\usage{
makeDTLZ5Function(dimensions, n.objectives)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Number of decision variables.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Builds and returns the multi-objective DTLZ5 test problem. This problem
can be characterized by a disconnected Pareto-optimal front in the search
space. This introduces a new challenge to evolutionary multi-objective
optimizers, i.e., to maintain different subpopulations within the search
space to cover the entire Pareto-optimal front.

The DTLZ5 test problem is defined as follows:

Minimize \eqn{f_1(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(\theta_1\pi/2) \cos(\theta_2\pi/2) \cdots \cos(\theta_{M-2}\pi/2) \cos(\theta_{M-1}\pi/2),}{
f[1](X) = (1 + g(XM)) * cos(theta[1] * pi/2) * cos(theta[2] * pi/2) * ... * cos(theta[M-2] * pi/2) * cos(theta[M-1] * pi/2)}

Minimize \eqn{f_2(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(\theta_1\pi/2) \cos(\theta_2\pi/2) \cdots \cos(\theta_{M-2}\pi/2) \sin(\theta_{M-1}\pi/2),}{
f[2](X) = (1 + g(XM)) * cos(theta[1] * pi/2) * cos(theta[2] * pi/2) * ... * cos(theta[M-2] * pi/2) * sin(theta[M-1] * pi/2)}

Minimize \eqn{f_3(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(\theta_1\pi/2) \cos(\theta_2\pi/2) \cdots \sin(\theta_{M-2}\pi/2),}{
f[3](X) = (1 + g(XM)) * cos(theta[1] * pi/2) * cos(theta[2] * pi/2) * ... * sin(theta[M-2] * pi/2)}

\eqn{\vdots\\}{...}

Minimize \eqn{f_{M-1}(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(\theta_1\pi/2) \sin(\theta_2\pi/2),}{
f[M-1](X) = (1 + g(XM)) * cos(theta[1] * pi/2) * sin(theta[2] * pi/2)}

Minimize \eqn{f_{M}((1+g(\mathbf{x}_M)) \sin(\theta_1\pi/2),}{
f[M](X) = (1 + g(XM)) * sin(theta[1] * pi/2)}

with \eqn{0 \leq x_i \leq 1}{0 <= x[i] <= 1}, for \eqn{i=1,2,\dots,n,}{i=1,2,...,n}

where \eqn{\theta_i = \frac{\pi}{4(1+ g(\mathbf{x}_M))} (1+2g(\mathbf{x}_M)x_i),}{
theta[i] = pi / (4 * (1 + g(XM))) * (1 + 2 * g(XM) * x[i]),}
for \eqn{i = 2,3,\dots,(M-1)}{i = 2,3,...,(M-1)}

and \eqn{g(\mathbf{x}_M) = \sum\limits_{x_i\in\mathbf{x}_M}(x_i-0.5)^2}{
g(XM) = sum{x[i] in XM} {(x[i] - 0.5)^2}}
}
\note{
This problem definition does not exist in the succeeding work of Deb et al. (K. Deb
and L. Thiele and M. Laumanns and E. Zitzler (2002). Scalable multi-objective optimization
test problems, Proceedings of the IEEE Congress on Evolutionary Computation, pp. 825-830).\cr
Also, note that in case of a bi-objective scenario (\code{n.objectives = 2L}) DTLZ2 and DTLZ5 are identical.
}
\references{
K. Deb and L. Thiele and M. Laumanns and E. Zitzler. Scalable
Multi-Objective Optimization Test Problems. Computer Engineering and Networks
Laboratory (TIK), Swiss Federal Institute of Technology (ETH) Zurich, 112, 2001
}
