% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_serial_interval_density.R
\name{get_serial_interval_density}
\alias{get_serial_interval_density}
\title{Dataframe with dates and contact symptom begin probability}
\usage{
get_serial_interval_density(
  symptom_begin_date,
  max_serial_interval_days = 20,
  shape_serial = 2.154631545,
  rate_serial = 0.377343528
)
}
\arguments{
\item{symptom_begin_date}{Date, when the index person got symptoms.}

\item{max_serial_interval_days}{Number of serial interval days.}

\item{shape_serial}{Number, the shape parameter for the gamma distribution.}

\item{rate_serial}{Number, the rate parameter for the gamma distribution.}
}
\value{
Dataframe with dates and contact symptom begin probability.
}
\description{
Creates a dataframe containing probability
that a contact will start showing symptoms (serial interval)
at a particular date/time, given the symptom_begin_date.
}
\details{
shape_serial and rate_serial are the parameters of the gamma distribution
for the serial interval derived from Najafi et al. (2020).
}
\examples{
get_serial_interval_density(as.Date("2022-03-22"))
get_serial_interval_density(as.Date("2022-03-22"), max_serial_interval_days = 20,
                            shape_serial = 2.15, rate_serial = 0.38)

}
\references{
Najafi F et al. (2020) "Serial interval and
time-varying reproduction number estimation for COVID-19 in western Iran.".
\emph{New Microbes and New Infections}, 36: 100715.
}
