% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_infection_density.R
\name{get_infection_density}
\alias{get_infection_density}
\title{Dataframe with dates and probability of infection}
\usage{
get_infection_density(
  symptom_begin_date,
  max_incubation_days = 14,
  meanlog = 1.69,
  sdlog = 0.55
)
}
\arguments{
\item{symptom_begin_date}{Date, when the person gets symptoms.}

\item{max_incubation_days}{Number of incubation days.}

\item{meanlog}{Number, the parameter of mean from the log-normal distribution.}

\item{sdlog}{Number, the parameter of sd from the log-normal distribution.}
}
\value{
Dataframe with dates and probability of infection.
}
\description{
Creates a dataframe containing probability of infection
occurring at a particular date/time,
given the symptom_begin_date.
}
\details{
meanlog and sdlog are the log-normal distribution parameters derived from
the incubation period characteristics described in Xin et al. (2021).
}
\examples{
get_infection_density(as.Date("2022-03-22"))
get_infection_density(as.Date("2022-03-22"), max_incubation_days = 14, meanlog = 1.69, sdlog = 0.55)

}
\references{
Xin H, Wong JY, Murphy C et al. (2021) "The Incubation Period
Distribution of Coronavirus Disease 2019: A Systematic Review and Meta-Analysis".
\emph{Clinical Infectious Diseases}, 73(12): 2344-2352.
}
