% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcure.R
\name{smcure}
\alias{smcure}
\title{Title}
\usage{
smcure(
  formula,
  cureform,
  offset = NULL,
  data,
  na.action = na.omit,
  model = c("aft", "ph"),
  link = "logit",
  Var = TRUE,
  emmax = 50,
  eps = 1e-07,
  nboot = 100
)
}
\arguments{
\item{formula}{a formula object}

\item{cureform}{specifies the variables in the incidence}

\item{offset}{variable(s) with coefficient 1 in PH model or AFT model}

\item{data}{a data.frame in which to interpret the variables named in the formula and cureform}

\item{na.action}{a missing-data filter function. By default na.action = na.omit}

\item{model}{specifies your model ph or aft}

\item{link}{incidence part}

\item{Var}{By default Var = TRUE}

\item{emmax}{maximum iteration number}

\item{eps}{convergence criterion}

\item{nboot}{number of bootstrap sampling}
}
\value{
a smcure object
}
\description{
Title
}
\examples{
data(e1684)
pd <- smcure(Surv(FAILTIME,FAILCENS)~TRT+SEX+AGE,
cureform=~TRT+SEX+AGE,data=e1684,model="ph",
Var = FALSE)
printsmcure(pd,Var = FALSE)
}
