% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.custom}
\alias{smbinning.custom}
\title{Customized Binning}
\usage{
smbinning.custom(df, y, x, cuts)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot. Name "default" is not allowed.}

\item{x}{Continuous characteristic. At least 5 different values. Value \code{Inf} is not allowed. 
Name of \code{x} must not have a dot.}

\item{cuts}{Vector with the cutpoints selected by the user. It does not have a default so user must define it.}
}
\value{
The command \code{smbinning.custom} generates and object containing the necessary info and utilities for binning.
The user should save the output result so it can be used 
with \code{smbinning.plot}, \code{smbinning.sql}, and \code{smbinning.gen}.
}
\description{
It gives the user the ability to create customized cutpoints.
}
\examples{
# Load library and its dataset
library(smbinning) # Load package and its data

# Custom cutpoints using percentiles (20\% each)
cbs1cuts=as.vector(quantile(smbsimdf1$cbs1, probs=seq(0,1,0.2), na.rm=TRUE)) # Quantiles
cbs1cuts=cbs1cuts[2:(length(cbs1cuts)-1)] # Remove first (min) and last (max) values

# Example: Customized binning
result=smbinning.custom(df=smbsimdf1,y="fgood",x="cbs1",cuts=cbs1cuts) # Run and save
result$ivtable # Tabulation and Information Value
}
