% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_api.R
\name{ss_get}
\alias{ss_get}
\alias{ss_post}
\alias{ss_delete}
\alias{ss_put}
\title{Execute curl commands for the Smartsheet API}
\usage{
ss_get(path, ...)

ss_post(path, body, ...)

ss_delete(path, ...)

ss_put(path, ...)
}
\arguments{
\item{path}{A character vector to add to the API url. See (https://smartsheet.redoc.ly/#section/Introduction)
for more information.}

\item{...}{Further arguments passed to \code{\link{ss_api}}}

\item{body}{A list of objects}
}
\value{
An httr::response object
}
\description{
\code{ss_get()} wraps the \code{httr::GET()} function
\code{ss_post()} wraps the \code{httr::POST()} function
\code{ss_put()} wraps the \code{httr::PUT()} function
\code{ss_delete()} wraps the \code{httr::DELETE()} function
}
\details{
Note that the environment variable SMARTSHEET_API_TOKEN should be defined in order to run this or any
other \code{smarsheetr} functions.
}
