% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_upload.R
\name{slackr_upload}
\alias{slackr_upload}
\title{Send a file to Slack}
\usage{
slackr_upload(
  filename,
  title = NULL,
  initial_comment = NULL,
  channels = Sys.getenv("SLACK_CHANNEL"),
  token = Sys.getenv("SLACK_TOKEN"),
  thread_ts = NULL
)
}
\arguments{
\item{filename}{path to file.}

\item{title}{Title of file.}

\item{initial_comment}{The message text introducing the file in specified channels.}

\item{channels}{Comma-separated list of channel names or IDs where the file will be shared.}

\item{token}{Authentication token bearing required scopes.}

\item{thread_ts}{Provide another message's ts value to upload this file as a reply. Never use a reply's ts value; use its parent instead.}
}
\value{
\code{httr} response object from \code{POST} call (invisibly)

\code{httr} response object from \code{POST} call (invisibly)
}
\description{
\code{slackr_upload} enables you upload files to Slack and
(optionally) post them to one or more channels (if \code{channels} is not empty).
}
\references{
\url{https://github.com/mrkaye97/slackr/pull/15/files}
}
\seealso{
\code{\link[=slackr_setup]{slackr_setup()}}, \code{\link[=slackr_dev]{slackr_dev()}}, \code{\link[=slackr_save]{slackr_save()}}
}
\author{
Quinn Weber (ctb), Bob Rudis (aut)
}
