% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets_manager.R
\name{aws_secrets_update}
\alias{aws_secrets_update}
\title{Update a secret}
\usage{
aws_secrets_update(id, secret, ...)
}
\arguments{
\item{id}{(character) The name or ARN of the secret. required}

\item{secret}{(character/raw) The text or raw data to encrypt and store
in this new version of the secret. AWS recommends for text to use a JSON
structure of key/value pairs for your secret value (see examples below).
required}

\item{...}{further named parameters passed on to \code{put_secret_value}
\url{https://www.paws-r-sdk.com/docs/secretsmanager_put_secret_value/}}
}
\value{
(list) with fields:
\itemize{
\item ARN
\item Name
\item VersionId
\item VersionStages
}
}
\description{
Update a secret
}
\details{
Note that we autogenerate a random UUID to pass to the
\code{ClientRequestToken} parameter of the \code{paws} function used internally
}
\examples{
\dontshow{if (aws_has_creds() && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
try({
# Create a secret
secret <- random_string("secret-", size = 16)
aws_secrets_create(
  name = secret,
  secret = '{"username":"debby","password":"kitty"}',
  description = "A string"
)

aws_secrets_get(secret)

# Update the secret
aws_secrets_update(
  id = secret,
  secret = '{"username":"debby","password":"kitten"}'
)

aws_secrets_get(secret)

# Cleanup
aws_secrets_delete(secret, ForceDeleteWithoutRecovery = TRUE)
})
\dontshow{\}) # examplesIf}
}
