% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack.R
\name{show_result_haystack}
\alias{show_result_haystack}
\alias{show_result_haystack.haystack}
\title{show_result_haystack}
\usage{
show_result_haystack(
  res.haystack,
  n = NULL,
  p.value.threshold = NULL,
  gene = NULL
)

\method{show_result_haystack}{haystack}(
  res.haystack,
  n = NULL,
  p.value.threshold = NULL,
  gene = NULL
)
}
\arguments{
\item{res.haystack}{A 'haystack' result object.}

\item{n}{If defined, the top "n" significant genes will be returned. Default: NA, which shows all results.}

\item{p.value.threshold}{If defined, genes passing this p-value threshold will be returned.}

\item{gene}{If defined, the results of this (these) gene(s) will be returned.}
}
\value{
A data.frame with 'haystack' results sorted by log.p.vals.
}
\description{
Shows the results of the 'haystack' analysis in various ways, sorted by significance. Priority of params is genes > p.value.threshold > n.
}
\details{
The output is a data.frame with the following columns:
* D_KL the calculated KL divergence.
* log.p.vals log10 p.values calculated from randomization.
* log.p.adj log10 p.values adjusted by Bonferroni correction.
}
\examples{
# using the toy example of the singleCellHaystack package

# running haystack
res <- haystack(dat.tsne, dat.expression)

# below are variations for showing the results in a table
# 1. list top 10 biased genes
show_result_haystack(res.haystack = res, n =10)
# 2. list genes with p value below a certain threshold
show_result_haystack(res.haystack = res, p.value.threshold=1e-10)
# 3. list a set of specified genes
set <- c("gene_497","gene_386", "gene_275")
show_result_haystack(res.haystack = res, gene = set)
}
