% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsimrelplot.R
\name{ggsimrelplot}
\alias{ggsimrelplot}
\title{Simulation Plot with ggplot: The true beta, relevant component and eigen structure}
\usage{
ggsimrelplot(
  obj,
  ncomp = min(obj$p, obj$n, 20),
  which = 1L:3L,
  layout = NULL,
  print.cov = FALSE,
  use_population = TRUE
)
}
\arguments{
\item{obj}{A simrel object}

\item{ncomp}{Number of components to plot}

\item{which}{A character indicating which plot you want as output, it can take \code{TrueBeta}, \code{RelComp} and \code{EstRelComp}}

\item{layout}{A layout matrix of how to layout multiple plots}

\item{print.cov}{Output estimated covariance structure}

\item{use_population}{Logical, TRUE if population values should be used and FALSE if sample values should be used}
}
\value{
A list of plots
}
\description{
Simulation Plot with ggplot: The true beta, relevant component and eigen structure
}
\examples{
sim.obj <- simrel(n = 100, p = 16, q = c(3, 4, 5),
   relpos = list(c(1, 2), c(3, 4), c(5, 7)), m = 5,
   ypos = list(c(1, 4), 2, c(3, 5)), type = "multivariate",
   R2 = c(0.8, 0.7, 0.9), gamma = 0.8)

ggsimrelplot(sim.obj, layout = matrix(c(2, 1, 3, 1), 2))

ggsimrelplot(sim.obj, which = c(1, 2), use_population = TRUE)

ggsimrelplot(sim.obj, which = c(1, 2), use_population = FALSE)

ggsimrelplot(sim.obj, which = c(1, 3), layout = matrix(c(1, 2), 1))
}
\concept{simulation plot}
