% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simstudy.prop}
\alias{simstudy.prop}
\title{simstudy.prop}
\usage{
simstudy.prop(
  n,
  p.actual = 0.5,
  p.hypothesized = 0.5,
  num.experiments = 1,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  correct = TRUE,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  experiment.name = "experiment",
  value.name = "x",
  seed = 7261,
  vstr = 3.6
)
}
\arguments{
\item{n}{A numeric value for the number of observations in each experiment.}

\item{p.actual}{A numeric value for the actual probability of success.}

\item{p.hypothesized}{A numeric value for the hypothesized probability of success.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{alternative}{See help(prop.test).}

\item{conf.level}{See help(prop.test).}

\item{correct}{See help(prop.test).}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{value.name}{A character value providing the name for the simulated values.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A list containing the following components:

\itemize{
  \item{\code{simdat.prop}}{A data frame of the simulated proportions.}
  \item{\code{test.statistics.prop}}{A data frame containing the results of the proportion tests.}
  \item{\code{sim.analysis.prop}}{A data frame containing the analysis of the simulated study for proportions.}
}
}
\description{
simstudy.prop
}
\examples{
study.prop <- simstudy.prop(n = 30, p.actual = 0.42,
p.hypothesized = 0.5, num.experiments = 2, alternative = "less",
 conf.level = 0.92, correct = TRUE, the.quantiles = c(0.04, 0.5, 0.96),
 experiment.name = "simulation_id", value.name = "success", seed = 8001)
}
