% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.t2.test}
\alias{sim.t2.test}
\title{sim.t2.test}
\usage{
sim.t2.test(
  simdat.t2,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  var.equal = FALSE,
  conf.level = 0.95,
  experiment.name = "experiment",
  group.name = "group",
  x.value = "x",
  y.value = "y",
  value.name = "value"
)
}
\arguments{
\item{simdat.t2}{Data for use in two-sample t tests across one or more experiments.  Structure is in the form returned by the function simitation::sim.t2().}

\item{alternative}{See help(t.test).}

\item{mu}{See help(t.test)}

\item{paired}{See help(t.test)}

\item{var.equal}{See help(t.test)}

\item{conf.level}{See help(t.test)}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{group.name}{A character value providing the name of the column of the group labels.}

\item{x.value}{A character value providing a label for the first group in the two-sample t test in the column of data named by group.name.}

\item{y.value}{A character value providing a label for the second group in the two-sample t test in the column of data named by group.name.}

\item{value.name}{A character value providing the name of the column of the values.}
}
\value{
A data frame or data.table containing the results of two-sample t-tests
        performed on the data generated by the 'sim.t2' function.
}
\description{
sim.t2.test
}
\examples{

simdat.t2 <- sim.t2(nx = 30, ny = 40, meanx = 0, meany = 0.2, sdx = 1,
sdy = 1, num.experiments = 2, experiment.name = "experiment",
group.name = "group", x.value = "x", y.value = "y", value.name = "value",
seed = 17)

test.statistics.t2 <- sim.t2.test(simdat.t2 = simdat.t2,
alternative = "less", mu = 0, conf.level = 0.9,
experiment.name = "experiment", group.name = "group", x.value = "x",
y.value = "y", value.name = "value")
}
