% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntFormatData.R
\name{IntFormatData}
\alias{IntFormatData}
\title{Transform Event Data into Interval Format for Classical Inference}
\usage{
IntFormatData(data, N_cols = 6:9, timeVar = FALSE, t_prime = NULL)
}
\arguments{
\item{data}{A \code{data.frame} or \code{data.table} containing event data with columns \code{ID}, \code{Time}, \code{Delta},
and counting process columns specified by \code{N_cols}.}

\item{N_cols}{Integer vector. Column indices of \code{data} that correspond to counting process variables.
Defaults to \code{6:9}.}

\item{timeVar}{Logical. If \code{TRUE}, the intervals are split at \code{t_prime} to allow time-varying covariate effects. Default is \code{FALSE}.}

\item{t_prime}{Numeric scalar. Time point at which to split intervals if \code{timeVar = TRUE}.}
}
\value{
A \code{data.table} with columns \code{tstart}, \code{tstop}, \code{k}, and other original variables,
formatted for survival analysis.
}
\description{
Converts simulated event history data with time-dependent covariates into an interval (start-stop) format,
suitable for classical survival analysis functions like \code{coxph}.
Adds interval start and stop times (\code{tstart}, \code{tstop}) and a counting variable \code{k} indexing events.
Optionally, the function can split intervals at a specified time point to accomadate estimation of time-varying effects.
}
\examples{
data <- simEventData(10)
IntFormatData(data)
}
