% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep_plot.R
\name{get_cum_mean_event_dev}
\alias{get_cum_mean_event_dev}
\title{Get cumulative mean event development}
\usage{
get_cum_mean_event_dev(
  df_visit,
  group = c("site_number", "study_id"),
  event_names = c("ae")
)
}
\arguments{
\item{df_visit}{Data frame with columns: study_id, site_number, patnum, visit,
n_ae.}

\item{group}{character, grouping variable, one of: c("site_number", "study_id")}

\item{event_names}{vector, contains the event names, default = "event"}
}
\description{
Calculate average increase of events per visit and cumulative average increase.
}
\details{
This is more stable than using mean cumulative patient count per visit
as only a few patients will contribute to later visits. Here the impact of the
later visits is reduced as they can only add or subtract to the results from
earlier visits and not shift the mean independently.
}
\examples{

df_visit <- sim_test_data_study(n_pat = 1000, n_sites = 10) \%>\%
  dplyr::rename(
    site_number = site_id,
    patnum = patient_id,
    n_ae = n_event
  )

get_cum_mean_event_dev(df_visit)
get_cum_mean_event_dev(df_visit, group = "study_id")

}
