% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{sg_change_nodes_p}
\alias{sg_change_nodes_p}
\alias{sg_change_edges_p}
\title{Change}
\usage{
sg_change_nodes_p(
  proxy,
  data,
  value,
  attribute,
  rate = c("once", "iteration"),
  refresh = TRUE
)

sg_change_edges_p(
  proxy,
  data,
  value,
  attribute,
  rate = c("once", "iteration"),
  refresh = TRUE
)
}
\arguments{
\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}

\item{data}{\code{data.frame} holding \code{delay} column.}

\item{value}{Column containing value.}

\item{attribute}{Name of attribute to change.}

\item{rate}{Rate at chich to refresh takes \code{once} refreshes once after all \code{values} have been changed, 
and \code{iteration} which refreshes at every iteration.}

\item{refresh}{Whether to refresh the graph after the change is made.}
}
\description{
Change nodes and edges attributes on the fly
}
\examples{

library(shiny)

nodes <- sg_make_nodes()
nodes$new_color <- "red"
edges <- sg_make_edges(nodes)

ui <- fluidPage(
  actionButton("start", "Change color"), 
  sigmajsOutput("sg")
) 

server <- function(input, output){

  output$sg <- renderSigmajs({
    sigmajs() \%>\%
      sg_nodes(nodes, id, size, color) \%>\%
      sg_edges(edges, id, source, target)
  })

  observeEvent(input$start, {
    sigmajsProxy("sg") \%>\% # use sigmajsProxy!
      sg_change_nodes_p(nodes, new_color, "color")
  })

}

 if(interactive()) shinyApp(ui, server) # run

}
