% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cd_uncured.R
\name{cd.uncured}
\alias{cd.uncured}
\title{Cross-validation conditional density of the susceptible population}
\usage{
cd.uncured(x, time, delta, logh3, logh4)
}
\arguments{
\item{x}{A numeric vector giving the covariate values.}

\item{time}{A numeric vector giving the observed times.}

\item{delta}{A numeric vector giving the values of the uncensoring indicator, where 1 indicates that the event of interest has been observed and 0 indicates that the observation is censored.}

\item{logh3}{The logarithm of the bandwidth for smoothing the time variable.}

\item{logh4}{The logarithm of the bandwidth for smoothing the covariate.}
}
\value{
A vector containing the cross-validation conditional density of the
susceptible population for each observation \eqn{(X_i, T_i)}.
}
\description{
This function implements a nonparametric cross-validation estimator for the conditional density  of the susceptible population, as proposed by Piñeiro-Lamas (2024) (see Equation (3.5)).
A leave-one-out cross-validation approach is considered to ensure that the sample used to construct the estimator and the point at which it is evaluated
are independent.
}
\examples{
# Some artificial data
set.seed(123)
n <- 50
x <- runif(n, -2, 2) # Covariate values
y <- rweibull(n, shape = 0.5 * (x + 4)) # True lifetimes
c <- rexp(n) # Censoring values
p <- exp(2*x)/(1 + exp(2*x)) # Probability of being susceptible
u <- runif(n)
t  <- ifelse(u < p, pmin(y, c), c) # Observed times
d  <- ifelse(u < p, ifelse(y < c, 1, 0), 0) # Uncensoring indicator
data <- data.frame(x = x, t = t, d = d)
suppressWarnings(cd.uncured(x, t, d, log(0.5), log(0.5)))
}
\references{
Piñeiro-Lamas, B. (2024). High dimensional single-index mixture cure models [PhD thesis]. Universidade da Coruña. Available at \url{https://ruc.udc.es/dspace/handle/2183/37035}
}
\seealso{
\code{\link[sicure]{cd.sm.uncured}}
}
