% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_json_logs}
\alias{read_json_logs}
\title{Read a directory containing JSON logs}
\usage{
read_json_logs(path)
}
\arguments{
\item{path}{Path of the directory containing JSON files or a vector of path to JSON files.}
}
\value{
a \code{list} of \code{data.table}
}
\description{
Read a directory containing JSON logs
}
\examples{

# Read all JSON in a directory
path_directory <- system.file("extdata/json", package = "shinylogs")
logs <- read_json_logs(path = path_directory)

# Read a single file
single_file <- dir(
  path = system.file("extdata/json", package = "shinylogs"),
  full.names = TRUE
)[1]
logs <- read_json_logs(path = single_file)

}
