% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer.R
\name{shinyTimer}
\alias{shinyTimer}
\title{shinyTimer widget}
\usage{
shinyTimer(
  inputId,
  label = NULL,
  hours = 0,
  minutes = 0,
  seconds = 0,
  type = "simple",
  background = "none",
  ...
)
}
\arguments{
\item{inputId}{The input id.}

\item{label}{The label to display above the countdown.}

\item{hours}{An integer, the starting time in hours for the countdown.}

\item{minutes}{An integer, the starting time in minutes for the countdown.}

\item{seconds}{An integer, the starting time in seconds for the countdown.}

\item{type}{The type of the countdown timer display ("simple", "mm:ss", "hh:mm:ss", "mm:ss.cs").}

\item{background}{The shape of the timer's container ("none", "circle", "rectangle").}

\item{...}{Any additional parameters you want to pass to the placeholder for the timer (\code{htmltools::tags$div}).}
}
\value{
A shiny UI component for the countdown timer.
}
\description{
shinyTimer widget
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      shinyTimer("timer", label = "Countdown Timer", seconds = 10)
    ),
    server = function(input, output, session) {
      observeEvent(input$start, {
        countDown("timer", session)
      })
    }
  )
}
}
