% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_navigate_frame.R
\name{lottie_navigate_frame}
\alias{lottie_navigate_frame}
\alias{lottie_goToAndStop}
\alias{lottie_goToAndPlay}
\title{Navigate to a Specific Animation Frame}
\usage{
lottie_goToAndStop(
  value,
  isFrame = TRUE,
  name = "all",
  session = shiny::getDefaultReactiveDomain()
)

lottie_goToAndPlay(
  value,
  isFrame = TRUE,
  name = "all",
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{value}{A numeric value specifying the frame or time to go to.}

\item{isFrame}{A logical value indicating whether \code{value} is a frame number (\code{TRUE}) or time (\code{FALSE}).}

\item{name}{A character string specifying the name of the 'Lottie' animation to control.
The default of "\code{all}" will control all animations within the 'shiny' application.}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
These functions are called for a side effect, and so there is no return value.
}
\description{
Navigate to a specific frame or time and either stop or play the animation.
}
\details{
\code{lottie_goToAndStop} moves the animation to a specific frame or time, then stops it.
Sends a custom session message \code{"lottie_js_goToAndStop"} containing the function arguments.

\code{lottie_goToAndPlay} moves the animation to a specific frame or time, then continues playback.
Sends a custom session message \code{"lottie_js_goToAndPlay"} containing the function arguments.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  ),
  actionButton("goToAndStop", "Go To Frame 10 And Stop"),
  actionButton("goToAndPlay", "Go To Frame 10 And Play")
)

server <- function(input, output, session) {
  observeEvent(input$goToAndStop, {
    lottie_goToAndStop(value = 10, isFrame = TRUE, name = "my_animation")
  })

  observeEvent(input$goToAndPlay, {
    lottie_goToAndPlay(value = 10, isFrame = TRUE, name = "my_animation")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{lottie_animation_methods}} for similar methods.
}
