% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candlestick_aggregator.R
\docType{class}
\name{candlestick_aggregator}
\alias{candlestick_aggregator}
\title{Aggregation which returns the candle sticks}
\format{
An \code{R6::R6Class} object
}
\description{
This aggregator divides the data into no-overlapping intervals
and calculate the first, maximum, minimum, and last values of the data,
which represents candle sticks.
}
\examples{
data(noise_fluct)
agg <- candlestick_aggregator$new(interleave_gaps = TRUE)
d_agg <- agg$aggregate(nanotime::as.nanotime(noise_fluct$time), noise_fluct$f500, 100)
fig <- plotly::plot_ly(
  x = d_agg$x, open = d_agg$open, high = d_agg$high, low = d_agg$low, close = d_agg$close,
  type = "candlestick"
  )

}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{candlestick_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-candlestick_aggregator-new}{\code{candlestick_aggregator$new()}}
\item \href{#method-candlestick_aggregator-clone}{\code{candlestick_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-candlestick_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-candlestick_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{candlestick_aggregator$new(..., interleave_gaps, coef_gap, NA_position)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, coef_gap, NA_position, ...}}{Arguments pass to the constructor of \code{aggregator} object.}

\item{\code{yupr, y, ylwr}}{Functions.
Statistical values are calculated using this function.
By default, \code{max, mean, min}, respectively.
Note that the NA values are omitted automatically.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-candlestick_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-candlestick_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{candlestick_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
