% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setZoom.R
\name{setZoom}
\alias{setZoom}
\title{Custom zoom}
\usage{
setZoom(id = NULL, class = NULL, scale = 1.05)
}
\arguments{
\item{id}{Use this argument if you want to target an individual element.}

\item{class}{The element to which the zoom should be applied.
For example, class is set to box.}

\item{scale}{Zoom scale. 1.05 by default (5\% bigger than the normal). We do not
recommand using higher values, except in some particular cases.}
}
\description{
Allow to apply a zoom on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyEffects)

  boxTag <- box(
   title = "A box",
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(

      setZoom(class = "box"),
      setZoom(id = "my-progress"),

      tags$h2("Add zoom to the box class"),
      fluidRow(boxTag, boxTag),
      tags$h2("Add zoom only to the first element using id"),
      tagAppendAttributes(
       progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE,
        vertical = TRUE
       ),
       id = "my-progress"
      ),
      progressBar(
       value = 50,
       status = "warning",
       size = "xs",
      )
     ),
     controlbar = dashboardControlbar(),
     title = "DashboardPage"
   ),
   server = function(input, output) { }
  )
}
}
