% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildNode.R
\name{buildNode}
\alias{buildNode}
\title{build single node element.}
\usage{
buildNode(
  id = NULL,
  width = 15,
  height = 15,
  shape = "ellipse",
  bgColor = "#48DBFB",
  bgOpacity = 1,
  bgFill = "solid",
  bgBlacken = 0,
  borderWidth = 0,
  borderStyle = "solid",
  borderColor = "#8395a7",
  borderOpacity = 1,
  isParent = FALSE,
  label = NULL,
  labelColor = "#8395a7",
  textOpacity = 1,
  fontSize = 16,
  textOutlineColor = "#222f3e",
  textOutlineOpacity = 1,
  textOutlineWidth = 0,
  textbgColor = "#FFF",
  textbgOpacity = 0,
  textBorderColor = "#222f3e",
  textBorderOpacity = 0,
  textBorderWidth = 0,
  parent = NULL,
  opacity = 1,
  pieSize = rep("0\%", 16),
  pieColor = rep("#000", 16),
  tooltip = "",
  position.x = 0,
  position.y = 0
)
}
\arguments{
\item{id}{id of node element. Also it will used as label. [string]}

\item{width}{Width. [numeric]}

\item{height}{Height. [numeric]}

\item{shape}{Shape of node body. polygon not accepted. [string]}

\item{bgColor}{Background color of node body. [string]}

\item{bgOpacity}{Opacity of backgroundColor. [numeric between 0 ~ 1]}

\item{bgFill}{The filling style of the node’s body; may be solid (default), linear-gradient, or radial-gradient. [string]}

\item{bgBlacken}{Blackens the node’s body for values from 0 to 1; whitens the node’s body for values from 0 to -1. [numeric between -1 ~ 1]}

\item{borderWidth}{The size of the node’s border. [numeric]}

\item{borderStyle}{The style of the node’s border; may be solid, dotted, dashed, or double. [string]}

\item{borderColor}{The colour of the node’s border. [string]}

\item{borderOpacity}{The opacity of the node’s border. [numeric between 0 ~ 1]}

\item{isParent}{whether this node is parent node or not [logical]}

\item{label}{node's label, default is node's id [string]}

\item{labelColor}{The color of node's label}

\item{textOpacity}{The opacity of the label text, including its outline. [numeric between 0 ~ 1]}

\item{fontSize}{The size of the label text. [numeric]}

\item{textOutlineColor}{The colour of the outline around the element’s label text. [string]}

\item{textOutlineOpacity}{The opacity of the outline on label text. [numeric between 0 ~ 1]}

\item{textOutlineWidth}{The size of the outline on label text. [numeric]}

\item{textbgColor}{colour to apply on the text background. [string]}

\item{textbgOpacity}{The opacity of the label background; the background is disabled for 0 (default value). [numeric between 0 ~ 1]}

\item{textBorderColor}{The colour of the border around the label. [string]}

\item{textBorderOpacity}{The width of the border around the label; the border is disabled for 0 (default value) [numeric between 0 ~ 1]}

\item{textBorderWidth}{The width of the border around the label. [numeric]}

\item{parent}{Indicate which node is parent of this node [string]}

\item{opacity}{Opacity of node itself. [numeric between 0 ~ 1]}

\item{pieSize}{Implement for pie node, consisted with 16 pie size[string]}

\item{pieColor}{Color for each pie part. [string]}

\item{tooltip}{Text for tooltip. [string]}

\item{position.x}{Location value (specify the location of of Node)}

\item{position.y}{Location value (specify the location of of Node)}
}
\value{
List typed Node element, consisted with data options ( id ) and style options ( width, shape... )
}
\description{
build single node element.
}
\seealso{
https://js.cytoscape.org/#style
}
