% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdown.R
\name{theme_selector}
\alias{theme_selector}
\title{Themes changer dropdown}
\usage{
theme_selector(input_id = "theme", label = "Choose theme")
}
\arguments{
\item{input_id}{Id of dropdown. \code{input[[input_id]]} returns the currently selected theme.}

\item{label}{Dropdown label.}
}
\description{
Themes changer dropdown
}
\examples{

if (interactive()) {
library(shiny)
 library(shiny.semantic)
  ui <- semanticPage(
    theme = "superhero",
    actionButton("action_button", "Press Me!"),
    textOutput("button_output"),
    theme_selector(),
    textOutput("theme")
  )
  server <- function(input, output, session) {
    output$button_output <- renderText(as.character(input$action_button))
    output$theme <- renderText(as.character(input$theme))
  }
  shinyApp(ui, server)
}

}
