% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_create.R
\name{gsheet_tables_create}
\alias{gsheet_tables_create}
\title{Create RegLog-valid database tables with googlesheets4}
\usage{
gsheet_tables_create(
  account_name = "account",
  reset_code_name = "reset_code",
  use_log = FALSE,
  log_name = "logs",
  user_data = NULL,
  hash_passwords = FALSE,
  gsheet_ss = NULL,
  gsheet_name = NULL,
  verbose = TRUE
)
}
\arguments{
\item{account_name}{Name of the sheet for storing user accounts credentials.
Defaults to 'account'. Mandatory spreadsheet.}

\item{reset_code_name}{Name of the sheet for storing generated password reset
codes. Defaults to 'reset_code'. Mandatory table.}

\item{use_log}{Should the sheet for keeping RegLogServer logs be
also created? Defaults to FALSE}

\item{log_name}{Name of the sheet for storing logs from RegLogServer object.
Used only if \code{use_log = TRUE}. Defaults to \code{logs}}

\item{user_data}{If you wish to import existing user database, you can input
data.frame with that table in this argument. It should contain columns:
username, password, email. Defaults to NULL.}

\item{hash_passwords}{If you are importing table of users upon tables creation,
you can also specify if the password should be hashed using \code{scrypt::hashPassword}.
Defaults to \code{FALSE}. If you have unhashed passwords in imported table, set
this option to \code{TRUE}.}

\item{gsheet_ss}{ID of the googlesheet that you want to append created tables
to. Defaults to \code{NULL}, which means creating new googlesheet.}

\item{gsheet_name}{If \code{gsheet_ss = NULL} and new googlesheet will be generated,
you can choose choose its name. If left at default \code{NULL}, name will be
generated randomly.}

\item{verbose}{Boolean specific if the actions made by function should be
printed back to the console. Defaults to \code{TRUE}. Don't affect \code{googlesheets4}
generated messages. To silence them, use \code{options(googlesheets4_quiet = TRUE)}
in the script before.}
}
\value{
ID of the googlesheet
}
\description{
Create RegLog-valid database tables with googlesheets4
}
\details{
Created spreadsheets will have following structure:
\itemize{
\item account (default name)
\itemize{
\item username: character
\item password: character
\item email: character
\item create_time: character
\item update_time: character
}
\item reset_code (default name)
\itemize{
\item user_id: numeric
\item reset_code: character
\item used: numeric
\item create_time: character
\item update_time: character
}
\item logs (default name, optional)
\itemize{
\item time: character
\item session: character
\item direction: character
\item type: character
\item note: character
}
}
}
\examples{
if (googlesheets4::gs4_has_token()) {
  library(shiny.reglog)
  
  # mockup user data
  user_data <- 
    data.frame(username = c("Whatever", "Hanuka", "Helsinki", "How_come"), 
               password = c("&f5*MSYj^niDt=V'3.[dyEX.C/", "\%}&B[fs\\\\}5PKE@,*+V\\\\tx9\"at]", 
                            "35z*ofW\\\\'G_8,@vCC`]~?e$Jm\%", "s:;r_eLn?-D6;oA-=\"^R(-Ew<x"), 
               email = c("what@mil.com", "hehe@soso.so", "nider@what.no", "crazzz@simpsy.com"))
  
  # create the tables and input the data (hashing the passwords in the process)
  id <- gsheet_tables_create(user_data = user_data,
                             hash_passwords = TRUE,
                             verbose = FALSE)
  
  # check generated googlesheet
  googlesheets4::gs4_get(id)
  
  # check the "account" sheet for credentials data
  googlesheets4::read_sheet(id, "account")
  
  # remove example googlesheets
  googledrive::drive_trash(id)
}
}
\seealso{
Other RegLog databases: 
\code{\link{DBI_tables_create}()},
\code{\link{mongo_tables_create}()}
}
\concept{RegLog databases}
