% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegLogServer.R
\docType{class}
\name{RegLogServer}
\alias{RegLogServer}
\title{Login and registration moduleServer}
\description{
RegLogServer is an R6 class to use for handling the whole
backend of login and registration component of your shinyApp.
}
\examples{
# Run only in interactive session #

if (interactive()) {
  
  library(shiny.reglog)
  
  # for exemplary setup temporary SQLite database will be created
  library("DBI")
  library("RSQLite")
  temp_sqlite <- tempfile(fileext = ".sqlite")
  conn <- DBI::dbConnect(RSQLite::SQLite(),
                         dbname = temp_sqlite)
  DBI_tables_create(conn)
  DBI::dbDisconnect(conn)
  
  # create minimalistic UI
  ui <- navbarPage(
    title = "RegLog system",
    tabPanel("Register", RegLog_register_UI("custom_id")),
    tabPanel("Login", RegLog_login_UI("custom_id")),
    tabPanel("Credentials edit", RegLog_credsEdit_UI("custom_id")),
    tabPanel("Password reset", RegLog_resetPass_UI("custom_id"))
  )
  
  # create server logic
  server <- function(input, output, session) {
    
    # create dbConnector with connection to the temporary SQLite database
    dbConnector <- RegLogDBIConnector$new(
      driver = RSQLite::SQLite(),
      dbname = temp_sqlite)
    
    # create mockup mailConnector
    mailConnector <- RegLogConnector$new()
    
    # create RegLogServer
    RegLog <- RegLogServer$new(
      dbConnector = dbConnector,
      mailConnector = mailConnector,
      ## all arguments below are optional! ##
      app_name = "RegLog example",
      app_address = "https://reglogexample.com",
      lang = "en",
      # custom texts as a named list with strings
      custom_txts = list(
        user_id = "Name of the user",
        register_success_t= "Congratulations - you have been registered in 
                             successfully with RegLog system!"),
      # use modals as a named list of FALSE to inhibit specific modal
      use_modals = list(
        login_success = FALSE),
      # custom module id - provide the same to the UI elements!
      module_id = "custom_id")
  }
  
  shinyApp(ui, server)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{is_logged}}{reactiveVal containing logical indicating if the user
is logged in}

\item{\code{user_id}}{reactiveVal containing character specifying the logged
user name. If the user is not logged in, it will consist
of uuid generated with \code{uuid::UUIDgenerate}}

\item{\code{user_mail}}{reactiveVal cantaining character string specifying the
logged user mail. When not logged in, it contains NULL.}

\item{\code{account_id}}{reactiveVal caintaining integer specifying the logged
user account's id number: for SQL database it is equal to the value
contained withing \code{id} variable. For googlesheets database it is equal to
the row number - 1 (the header). If not logged, it contains NULL.}

\item{\code{mail_message}}{reactiveVal containing most recent RegLogConnectorMessage
received from mailConnector}

\item{\code{message}}{reactiveVal containing most recent RegLogConnectorMessage
received from dbConnector or generated by RegLogServer itself.}

\item{\code{module_id}}{character storing ID for reglog_system module.}

\item{\code{dbConnector}}{\code{RegLogConnector} object used for communication with the
database. Build-in children classes are \code{RegLogDBIConnector} and
\code{RegLogGsheetConnector}.}

\item{\code{mailConnector}}{\code{RegLogConnector} object used for sending emails.
Built-in children classes are \code{RegLogEmayiliConnector} and
\code{RegLogGmailrConnector}.}

\item{\code{log}}{list containing all messages send and received.}

\item{\code{UI_list_login}}{reactiveVal holding the tagList of whole login UI.}

\item{\code{UI_list_resetPass}}{reactiveVal holding the tagList of whole resetPass UI.}

\item{\code{UI_list_credsEdit}}{reactiveVal holding the tagList of whole credentioals
edit UI.}

\item{\code{UI_list_register}}{reactiveVal holding the tagList of whole register UI.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RegLogServer-new}{\code{RegLogServer$new()}}
\item \href{#method-RegLogServer-logout}{\code{RegLogServer$logout()}}
\item \href{#method-RegLogServer-get_logs}{\code{RegLogServer$get_logs()}}
\item \href{#method-RegLogServer-clone}{\code{RegLogServer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogServer-new"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogServer-new}{}}}
\subsection{Method \code{new()}}{
Initialize 'ReglogServer' moduleServer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogServer$new(
  dbConnector,
  mailConnector,
  app_name = basename(getwd()),
  app_address = NULL,
  lang = "en",
  custom_txts = NULL,
  use_modals = TRUE,
  module_id = "login_system"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dbConnector}}{object of class \code{RegLogConnector} handling the reads
from and writes to database.
Two available in the package are \code{RegLogDBIConnector} and \code{RegLogGsheetsConnector}.
See their documentation for more information about usage and creation of
custom dbConnectors.}

\item{\code{mailConnector}}{object of class \code{RegLogConnector} handling the email
sending to the user for register confirmation and password reset.
Two available in the package are \code{RegLogEmayiliConnector} and
\code{RegLogGmailrConnector}. See their documentation for more information
about usage and creation of custom mailConnectors.}

\item{\code{app_name}}{Name of the app to refer during correspondence to users.
Defaults to the name of working directory.}

\item{\code{app_address}}{URL to refer to during correspondence to users. If left
at NULL, the URL will be parsed from \code{session$clientData}.}

\item{\code{lang}}{character specyfiyng which language to use for all texts
generated in the UI. Defaults to 'en' for English. Currently 'pl' for
Polish is also supported.}

\item{\code{custom_txts}}{named list containing character strings with custom
messages. Defaults to NULL, so all built-in strings will be used.}

\item{\code{use_modals}}{either logical indicating if all (\code{TRUE}) or none (\code{FALSE})
modalDialogs should be shown or character vector indicating which modals
should be shown. For more information see details.}

\item{\code{module_id}}{Character declaring the id of the module. Defaults to 'login_system'.
Recommended to keep it that way, unless it would cause any namespace issues.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogServer-logout"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogServer-logout}{}}}
\subsection{Method \code{logout()}}{
Method logging out logged user
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogServer$logout()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogServer-get_logs"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogServer-get_logs}{}}}
\subsection{Method \code{get_logs()}}{
Method to receive all saved logs from the object in the form
of single data.frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogServer$get_logs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogServer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogServer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogServer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
