% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{runDestroyExample}
\alias{runDestroyExample}
\title{Run `shiny.destroy` example}
\usage{
runDestroyExample(example = NA, ...)
}
\arguments{
\item{example}{The name of the example to run, or \code{NA} (the default) to
list the available examples.}

\item{...}{Additional parameters sent to `shiny::runExample`}
}
\value{
The shiny application displayed in the specified location.
}
\description{
To see how the `shiny.destroy` works, examples are provided within
the package.
}
\details{
The following examples are available:

\describe{
\item{01_boxes}{A simple application where the "create" button will
load a simple box with a "destroy" button. This highlights the full
removal of the module when the button is pressed.}
\item{02_sleep}{An application that has 2 side by side modules, one
using \{shiny\} to remove the UI and the other using \{shiny.destroy\}
to fully remove the boxes to display the incremental time gain from
removing the long-running observers.}
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
runDestroyExample("01_boxes")
\dontshow{\}) # examplesIf}
}
