% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{HTMLSelect}
\alias{HTMLSelect}
\alias{HTMLSelect.shinyInput}
\title{HTML select}
\usage{
HTMLSelect(...)

HTMLSelect.shinyInput(inputId, ..., value = defaultValue)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{value}{Initial value.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/html-select}
}
\examples{
library(shiny.blueprint)
library(shiny)

setInput <- function(inputId, accessor = NULL) {
  JS(paste0("x => Shiny.setInputValue('", inputId, "', x", accessor, ")"))
}

options <- list(
  list(value = "a", label = "Apples"),
  list(value = "b", label = "Bananas"),
  list(value = "c", label = "Cherries")
)

ui <- function(id) {
  ns <- NS(id)
  tagList(
    HTMLSelect(
      onChange = setInput(ns("choice1"), ".target.value"),
      options = options
    ),
    textOutput(ns("text1")),
    br(),
    HTMLSelect.shinyInput(
      inputId = ns("choice2"),
      value = "b",
      options = options
    ),
    textOutput(ns("text2"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$text1 <- renderText(deparse(input$choice1))
    output$text2 <- renderText(deparse(input$choice2))
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
