% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_pareto_chart_grouped.R
\name{draw_pareto_chart_grouped}
\alias{draw_pareto_chart_grouped}
\title{Draw Grouped Pareto Chart}
\usage{
draw_pareto_chart_grouped(
  data,
  cat_var,
  grouping_var,
  summarize = FALSE,
  continuous_var,
  drop_na = TRUE,
  highlight_first_n_items = 0,
  lump_last_n_items = 0,
  lumped_cat_name = "Other",
  color = "one",
  scale = "numeric",
  accuracy = 1,
  title_label = "Pareto Chart",
  analysis_desc_label = NULL,
  axis_text_size = 10,
  x_axis_span = "free"
)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{cat_var}{Categorical variable (required)}

\item{grouping_var}{Grouping variable (required)}

\item{summarize}{Logical. If FALSE, default, the function expects total counts of each category of the categorical variable. If TRUE, individual values within each category are automatically summed up and ranked. (required)}

\item{continuous_var}{Continuous variable to rank by (e.g. sum, frequency etc.). Not required if summarize argument is set to TRUE. (required)}

\item{drop_na}{Logical. If TRUE, default, NA values of the categorical variable are dropped. (required)}

\item{highlight_first_n_items}{Specify the top n items to be highlighted. By default, it is set to 0. (optional)}

\item{lump_last_n_items}{Specify the last n items to be lumped into one category. By default, it is set to 0. (optional)}

\item{lumped_cat_name}{Name lumped category. By default, it is set to "Other". (optional)}

\item{color}{Set panel fill color for facets. Options are "one" (one color) or "multi" (each panel is a different color). By default, it is set to "one". (optional)}

\item{scale}{Specify an acceptable argument for scale. Acceptable arguments are "numeric", "percent", "dollar", "dollar-k" or "dollar-M". By default, it is set to "numeric" (optional)}

\item{accuracy}{Number to round to. Default value is set to 1. If NULL, values will be rounded to the nearest integer. (optional)}

\item{title_label}{Specify plot title. By default, it is set to display "Pareto Chart" (optional)}

\item{analysis_desc_label}{Specify plot analysis desc label (subtitle). By default, it is set to display CONTINUOUS VARIABLE COLUMN NAME "by" CATEGORICAL VARIABLE COLUMN NAME (optional)}

\item{axis_text_size}{Set axis text size. By default, it is set at 10. (optional)}

\item{x_axis_span}{Set X axis span. Options are "free" (a different span for each panel based on range of values for each panel) and "fixed" (the X axes in all panels are set to span the total range of all values). By default, it is set to "free". (optional)}
}
\value{
A 'ggplot' object
}
\description{
Draws a small multiples type of Pareto Chart grouped by a categorical variable
}
