% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSS2LL.R
\name{formatPLSS}
\alias{formatPLSS}
\title{Format Public Land Survey System (PLSS) Components}
\usage{
formatPLSS(p)
}
\arguments{
\item{p}{\code{data.frame} with components of a PLSS description, see details.}
}
\value{
A vector of PLSS codes.
}
\description{
Format Public Land Survey System (PLSS) components into a string that can be interpreted by the US Bureau of Land Management (BLM) PLSS encoding and decoding web service.
}
\details{
This function is typically accessed as a helper function to prepare data for use by the \code{PLSS2LL()} function. The \code{data.frame} 'p' must contain:
\itemize{
\item id: a unique ID over rows
\item t: township number and direction
\item r: range number and direction
\item m: base meridian code
\item type: one of 'SN', 'PB', or 'UN'
}

and can optioninally contain:
\itemize{
\item s: section number
\item q: quarter section specification
\item qq: quarter-quarter section specification
}
}
\note{
This function requires the following packages: stringi.
}
\examples{
# create PLSS description components
d <- data.frame(
  id = 1:3,
  qq = c('SW', 'SW', 'SE'),
  q = c('NE', 'NW', 'SE'),
  s = c(17, 32, 30),
  t = c('T36N', 'T35N', 'T35N'),
  r = c('R29W', 'R28W', 'R28W'),
  type = 'SN',
  m = 'MT20'
)
# generate formatted PLSS codes
# and save back to original data.frame
d$plssid <- formatPLSS(d)

# convert to geographic coordinates
# PLSS2LL(d)

}
\seealso{
\code{\link[=PLSS2LL]{PLSS2LL()}}
}
\author{
D.E. Beaudette, Jay Skovlin, A.G. Brown
}
