% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.sgd.R
\name{predict.sgd}
\alias{predict.sgd}
\alias{predict_all}
\title{Model Predictions}
\usage{
\method{predict}{sgd}(object, newdata, type = "link", ...)

predict_all(object, newdata, ...)
}
\arguments{
\item{object}{object of class \code{sgd}.}

\item{newdata}{design matrix to form predictions on}

\item{type}{the type of prediction required. The default "link" is
on the scale of the linear predictors; the alternative '"response"'
is on the scale of the response variable. Thus for a default
binomial model the default predictions are of log-odds
(probabilities on logit scale) and 'type = "response"' gives the
predicted probabilities. The '"terms"' option returns a matrix
giving the fitted values of each term in the model formula on the
linear predictor scale.}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
Form predictions using the estimated model parameters from stochastic
gradient descent.
}
\details{
A column of 1's must be included to \code{newdata} if the
parameters include a bias (intercept) term.
}
