% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_transform.R
\name{sfc_rotate,sfc_sequence-method}
\alias{sfc_rotate,sfc_sequence-method}
\alias{sfc_rotate}
\alias{^.sfc_sequence}
\alias{sfc_hflip,sfc_sequence-method}
\alias{sfc_hflip}
\alias{sfc_vflip,sfc_sequence-method}
\alias{sfc_vflip}
\alias{sfc_dflip,sfc_sequence-method}
\alias{sfc_dflip}
\alias{sfc_reverse,sfc_sequence-method}
\alias{sfc_reverse}
\alias{rev.sfc_sequence}
\title{Transformations of a sequence}
\usage{
\S4method{sfc_rotate}{sfc_sequence}(p, rot)

\method{^}{sfc_sequence}(e1, e2)

\S4method{sfc_hflip}{sfc_sequence}(p, fix_ends = FALSE, bases = NULL)

\S4method{sfc_vflip}{sfc_sequence}(p, fix_ends = FALSE, bases = NULL)

\S4method{sfc_dflip}{sfc_sequence}(p, slop = 1L, fix_ends = FALSE, bases = NULL)

\S4method{sfc_reverse}{sfc_sequence}(p)

\method{rev}{sfc_sequence}(x)
}
\arguments{
\item{p, e1}{An \code{sfc_sequence} object.}

\item{rot, e2}{Rotation measured in the polar coordinate system, in degrees.}

\item{fix_ends}{By default, the curve is flipped as a complete whole, which means, the associated entry and exit directions of the curve
is also adjusted accordingly. When flipping subunits in a curve, e.g. level-1 subunits in a Peano curve, we want the
entry and exit direction of the subunit not changed so that the subunits are still connected in the curve after the flipping. In this
case, \code{fix_ends} can be set to \code{TRUE}, then only the subunits are flipped while the connections to neighbouring subunits are not affected.
See the \strong{Examples} section.}

\item{bases}{A list of base patterns, consider to use \code{\link{BASE_LIST}}. It is only used when \code{fix_ends = TRUE}.}

\item{slop}{Slop of the diagonal. Value can only be 1 or -1.}

\item{x}{An \code{sfc_sequence} object.}
}
\value{
An \code{sfc_sequence} object.
}
\description{
Transformations of a sequence
}
\details{
\itemize{
\item \code{sfc_rotate()} and \verb{^()} rotate each base pattern.
\item \code{sfc_hflip()} flips a sequence horizontally.
\item \code{sfc_vflip()} flips a sequence vertically.
\item \code{sfc_dflip()} flips a sequence against a diagonal line (with slop 1 or -1).
}
}
\examples{
p = sfc_3x3_meander("R", 2, rot = -90)
draw_multiple_curves(
    p, 
    sfc_hflip(p), 
    sfc_hflip(p, fix_ends = TRUE), 
    nrow = 1)
p = sfc_3x3_meander("L", 2, rot = -90)
draw_multiple_curves(
    p, 
    sfc_vflip(p), 
    sfc_vflip(p, fix_ends = TRUE), 
    nrow = 1)
p = sfc_3x3_peano("I", 2)
draw_multiple_curves(
    p, 
    sfc_dflip(p, 1), 
    sfc_dflip(p, 1, fix_ends = TRUE), 
    nrow = 1)
}
