% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{sst_au_get_summary}
\alias{sst_au_get_summary}
\title{Website audit summary}
\usage{
sst_au_get_summary(
  api_token = Sys.getenv("SERPSTAT_API_TOKEN"),
  report_id = NULL
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}

\item{report_id}{(required) ID of the audit report to get data from.}
}
\value{
Returns the basic metrics for audited website.
}
\description{
Returns the basic stats for the finished audit returns, including number of
checked pages, issues by priority, domain optimization score.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/uup6axm96za8m-get-basic-info}{here}.
}

\section{API credits consumption}{
 0.
}

\examples{
\dontrun{
sst_au_get_summary(
  report_id = report_id
  )$data
}
}
