% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{interval_table}
\alias{interval_table}
\title{Interval table for linking and standardising intervals}
\format{
A \code{data.frame} with 302 rows and 4 variables:
\describe{
\item{interval_max}{A character denoting the oldest international
geological stage.}
\item{interval_min}{A character denoting the youngest international
geological stage.}
\item{code}{A character denoting the original interval abbreviation.}
\item{original_interval}{A character denoting the original interval.}
}
}
\usage{
interval_table
}
\description{
This dataset provides the interval table used for updating the intervals
in Sepkoski's fossil marine animal genera compendium with the
\href{https://stratigraphy.org/ICSchart/ChronostratChart2022-02.pdf}{International Geological Time Scale 2022}. This table
was generated based on published literature and the \href{https://timescalefoundation.org/resources/geowhen/index.html}{GeoWhen Database}. In the
majority of cases, this was a clear conversion. However, in several cases
reasonable interpretation was required.
}
\keyword{datasets}
