% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_stats.R
\name{sensitivity_stats}
\alias{sensitivity_stats}
\alias{sensitivity_stats.lm}
\alias{sensitivity_stats.fixest}
\alias{sensitivity_stats.numeric}
\title{Sensitivity statistics for regression coefficients}
\usage{
sensitivity_stats(...)

\method{sensitivity_stats}{lm}(
  model,
  treatment,
  q = 1,
  alpha = 0.05,
  reduce = TRUE,
  invert = FALSE,
  ...
)

\method{sensitivity_stats}{fixest}(
  model,
  treatment,
  q = 1,
  alpha = 0.05,
  reduce = TRUE,
  invert = FALSE,
  message = T,
  ...
)

\method{sensitivity_stats}{numeric}(
  estimate,
  se,
  dof,
  treatment = "treatment",
  q = 1,
  alpha = 0.05,
  reduce = TRUE,
  invert = FALSE,
  ...
)
}
\arguments{
\item{...}{arguments passed to other methods.}

\item{model}{An \code{lm} or \code{fixest} object with the outcome regression.}

\item{treatment}{A character vector with the name of the treatment variable
of the model.}

\item{q}{percent change of the effect estimate that would be deemed problematic.  Default is \code{1},
which means a reduction of 100\% of the current effect estimate (bring estimate to zero). It has to be greater than zero.}

\item{alpha}{significance level.}

\item{reduce}{should the bias adjustment reduce or increase the
absolute value of the estimated coefficient? Default is \code{TRUE}.}

\item{invert}{should IRV be computed instead of RV? (i.e. is the estimate insignificant?). Default is \code{FALSE}.}

\item{message}{should messages be printed? Default = TRUE.}

\item{estimate}{Coefficient estimate.}

\item{se}{standard error of the coefficient estimate.}

\item{dof}{residual degrees of freedom of the regression.}
}
\value{
A \code{data.frame} containing the following quantities:
\describe{
\item{treatment}{a character with the name of the treatment variable}
\item{estimate}{a numeric vector with the estimated effect of the treatment}
\item{se}{a numeric vector with  the estimated standard error of the treatment effect}
\item{t_statistics}{a numeric vector with  the t-value of the treatment}
\item{r2yd.x}{a numeric vector with  the partial R2 of the treatment and the outcome, see details in \code{\link{partial_r2}}}
\item{rv_q}{a numeric vector with  the robustness value of the treatment, see details  in \code{\link{robustness_value}}}
\item{rv_qa}{a numeric vector with the robustness value of the treatment considering statistical significance, see details  in \code{\link{robustness_value}}}
\item{f2yd.x }{a numeric vector with the partial (Cohen's) f2 of the treatment with the outcome, see details in \code{\link{partial_f2}}}
\item{dof}{a numeric vector with the degrees of freedom of the model}
}
}
\description{
Convenience function that computes the \code{\link{robustness_value}},
\code{\link{partial_r2}} and \code{\link{partial_f2}} of the coefficient of interest.
}
\examples{

## loads data
data("darfur")

## fits model
model <- lm(peacefactor ~ directlyharmed + age + farmer_dar + herder_dar +
             pastvoted + hhsize_darfur + female + village, data = darfur)

## sensitivity stats for directly harmed
sensitivity_stats(model, treatment = "directlyharmed")

## you can  also pass the numeric values directly
sensitivity_stats(estimate = 0.09731582, se = 0.02325654, dof = 783)

}
\references{
Cinelli, C. and Hazlett, C. (2020), "Making Sense of Sensitivity: Extending Omitted Variable Bias." Journal of the Royal Statistical Society, Series B (Statistical Methodology).
}
