% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initSENDFunctions.R
\name{genericQuery}
\alias{genericQuery}
\title{Execute database query and returns fetched rows.}
\usage{
genericQuery(dbToken, queryString, queryParams = NULL)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{queryString}{Mandatory, character.\cr
The select statement to execute}

\item{queryParams}{Optional, character.\cr
A variable with values for bind variable referenced in the where clause of
the select statement}
}
\value{
Data.table with the set of fetched rows
}
\description{
The function executes a SQL select statements in the database and returns
the fetched set of rows as a data.table.
}
\examples{

\dontrun{
genericQuery(dbToken,
             'select studyid, tsseq, tsgrpid, tsparmcd, tsval from ts')
genericQuery(dbToken,
             'select studyid, tsval from ts where tsprmcd = "SDESIGN" and studyid in (:1)',
             list("1234546","222333","444555"))
}
}
