% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.indtest}
\alias{print.indtest}
\title{Print Method for Independence Tests Between Categorical and Continuous Variables}
\usage{
\method{print}{indtest}(x, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{\code{"indtest"} class object.}

\item{digits}{minimal number of \emph{significant} digits.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None
}
\description{
Printing object of class \code{"indtest"}, by simple \link{print} method.
}
\examples{
# Man-made functionally dependent data --------------------------------------
n <- 30; R <- 3
x <- rep(0, n)
x[1:10] <- 0.3; x[11:20] <- 0.2; x[21:30] <- -0.1
y <- factor(rep(1:3, each = 10))
test <- mv_test(x, y)
print(test)
test_asym <- mv_test(x, y, test_type = "asym")
print(test_asym)

}
