% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSML.R
\docType{class}
\name{twostage-class}
\alias{twostage-class}
\alias{show,twostage-method}
\alias{summary,twostage-method}
\alias{anova,twostage-method}
\alias{vcov,twostage-method}
\alias{coef,twostage-method}
\alias{fitted.values,twostage-method}
\alias{fitted,twostage-method}
\alias{residuals,twostage-method}
\alias{resid,twostage-method}
\alias{nobs,twostage-method}
\title{Class for the Results of 2-Stage Maximum Likelihood (TSML) Estimation for
Missing Data}
\usage{
\S4method{show}{twostage}(object)

\S4method{summary}{twostage}(object, ...)

\S4method{anova}{twostage}(object, h1 = NULL, baseline = FALSE)

\S4method{nobs}{twostage}(object, type = c("ntotal", "ngroups",
  "n.per.group", "norig", "patterns", "coverage"))

\S4method{coef}{twostage}(object, type = c("free", "user"))

\S4method{vcov}{twostage}(object, baseline = FALSE)

\S4method{fitted.values}{twostage}(object, model = c("target", "saturated",
  "baseline"), type = "moments", labels = TRUE)

\S4method{fitted}{twostage}(object, model = c("target", "saturated",
  "baseline"), type = "moments", labels = TRUE)

\S4method{residuals}{twostage}(object, type = c("raw", "cor", "normalized",
  "standardized"))

\S4method{resid}{twostage}(object, type = c("raw", "cor", "normalized",
  "standardized"))
}
\arguments{
\item{object}{An object of class \code{twostage}.}

\item{...}{arguments passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.}

\item{h1}{An object of class \code{twostage} in which \code{object} is
nested, so that their difference in fit can be tested using
\code{anova} (see \strong{Value} section for details).}

\item{baseline}{\code{logical} indicating whether to return results for the
baseline model, rather than the default target (hypothesized) model.}

\item{type}{The meaning of this argument varies depending on which method it
it used for. Find detailed descriptions in the \strong{Value} section
under \code{coef}, \code{nobs}, and \code{residuals}.}

\item{model}{\code{character} naming the slot for which to return the
model-implied sample moments (see \code{fitted.values} description.)}

\item{labels}{\code{logical} indicating whether the model-implied sample
moments should have (row/column) labels.}
}
\value{
\item{show}{\verb{signature(object = "twostage"):} The \code{show} function
is used to display the results of the \code{anova} method, as well as the
header of the (uncorrected) target model results.}
\item{summary}{\verb{signature(object = "twostage", ...):} The summary
function prints the same information from the \code{show} method, but also
provides (and returns) the output of
\code{parameterEstimates(object@target, ...)} with corrected
\emph{SE}s, test statistics, and confidence intervals.  Additional
arguments can be passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
including \code{fmi = TRUE} to provide an estimate of the fraction of
missing information.}
\item{anova}{\verb{signature(object = "twostage", h1 = NULL, baseline = FALSE):}
The \code{anova} function returns the residual-based \eqn{\chi^2} test
statistic result, as well as the scaled \eqn{\chi^2} test statistic result,
for the model in the \code{target} slot, or for the model in the
\code{baseline} slot if \code{baseline = TRUE}.  The user can also provide
a single additional \code{twostage} object to the \code{h1} argument, in
which case \code{anova} returns residual-based and scaled
(\eqn{\Delta})\eqn{\chi^2} test results, under the assumption that the
models are nested.  The models will be automatically sorted according their
degrees of freedom.}
\item{nobs}{\verb{signature(object = "twostage", type = c("ntotal", "ngroups", "n.per.group", "norig", "patterns", "coverage")):}
The \code{nobs} function will return the total sample sized used in the
analysis by default.  Also available are the number of groups or the sample
size per group, the original sample size (if any rows were deleted because
all variables were missing), the missing data patterns, and the matrix of
coverage (diagonal is the proportion of sample observed on each variable,
and off-diagonal is the proportion observed for both of each pair of
variables).}
\item{coef}{\verb{signature(object = "twostage", type = c("free", "user")):}
This is simply a wrapper around the corresponding
\link[lavaan:lavaan-class]{lavaan::lavaan} method, providing point estimates from the
\code{target} slot.}
\item{vcov}{\verb{signature(object = "twostage", baseline = FALSE):} Returns
the asymptotic covariance matrix of the estimated parameters (corrected for
additional uncertainty due to missing data) for the model in the
\code{target} slot, or for the model in the \code{baseline} slot if
\code{baseline = TRUE}.}
\item{fitted.values, fitted}{\verb{signature(object = "twostage", model = c("target", "saturated", "baseline")):} This is simply a wrapper
around the corresponding \link[lavaan:lavaan-class]{lavaan::lavaan} method, providing
model-implied sample moments from the slot specified in the \code{model}
argument.}
\item{residuals, resid}{\verb{signature(object = "twostage", type = c("raw", "cor", "normalized", "standardized")):} This is simply a wrapper around the
corresponding \link[lavaan:lavaan-class]{lavaan::lavaan} method, providing residuals of
the specified \code{type} from the \code{target} slot.}
}
\description{
This class contains the results of 2-Stage Maximum Likelihood (TSML)
estimation for missing data.  The \code{summary}, \code{anova}, \code{vcov}
methods return corrected \emph{SE}s and test statistics.  Other methods are
simply wrappers around the corresponding \link[lavaan:lavaan-class]{lavaan::lavaan}
methods.
}
\section{Slots}{

\describe{
\item{\code{saturated}}{A fitted \link[lavaan:lavaan-class]{lavaan::lavaan} object containing the
saturated model results}

\item{\code{target}}{A fitted \link[lavaan:lavaan-class]{lavaan::lavaan} object containing the
target/hypothesized model results}

\item{\code{baseline}}{A fitted \link[lavaan:lavaan-class]{lavaan::lavaan} object containing the
baseline/null model results}

\item{\code{auxNames}}{A character string (potentially of \code{length == 0}) of any
auxiliary variable names, if used}
}}

\section{Objects from the Class}{
 Objects can be created via the
\code{\link[=twostage]{twostage()}} function.
}

\examples{

# See the example from the twostage function

}
\seealso{
\code{\link[=twostage]{twostage()}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
